% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_diversity.R
\name{VDJ_diversity}
\alias{VDJ_diversity}
\title{Calculates and plots common diversity and overlap measures for repertoires and alike. Require the vegan package}
\usage{
VDJ_diversity(
  VDJ,
  feature.columns,
  grouping.column,
  metric,
  subsample.to.same.n,
  pvalues.label.size,
  axis.label.size,
  platypus.version
)
}
\arguments{
\item{VDJ}{VDJ dataframe output from either the VDJ_analyse (platypus.version = "v2") or from the VDJ_GEX_matrix function (platypus.version = "v3")(VDJ_GEX_matrix.output[[1]])}

\item{feature.columns}{Character vector. One or more column names from the VDJ of which diversity or overlap metrics are calculated. if more than one column is provided (e.g. c("VDJ_cdr3s_aa","VJ_cdr3s_aa")) these columns will be pasted together before metric calculation. Defaults to "CDRH3_aa" if platypus.version == "v2" and "VDJ_cdr3s_aa" if platypus.version == "v3".}

\item{grouping.column}{Character. Column name of a column to group metrics by. This could be "sample_id" to calculate the metric for each sample. This column is required if metric = "simpson". If so, the simpson overlap index will be calculated pairwise for all combinations of elements in the grouping.column. Defaults to "none".}

\item{metric}{Character. Diversity or overlap metric to calculate. Can be c("richness", "bergerparker", "simpson", "ginisimpson", "shannon", "shannonevenness", "jaccard"). Defaults to "shannon". If jaccard is selected, a heatmap with the pairwise comparisons between all groups is returned. If any of the others is selected, a dotplot is returned}

\item{subsample.to.same.n}{Boolean defaults to TRUE. Whether to subsample larger groups down to the size of the smallest group}

\item{pvalues.label.size}{Numeric. Only used if overlap indices are calculated. Defaults to 4. Is passed on to ggplot theme}

\item{axis.label.size}{Numeric. Only used if overlap indices are calculated. Defaults to 12. Is passed on to ggplot theme}

\item{platypus.version}{Version of platypus to use. Defaults to "v3". If an output of the VDJ_analyze function is supplied, set to "v2". If an output of the VDJ_GEX_matrix function is supplied set to "v3"}
}
\value{
Returns a ggplot with the calculated metric for each group (if provided). Data is accessible via ggplot.output$data
}
\description{
Calculates and plots common diversity and overlap measures for repertoires and alike. Require the vegan package
}
\examples{

#Calculate shannon index for VDJ CDR3s by sample
plot <- VDJ_diversity(VDJ = Platypus::small_vgm[[1]], platypus.version = "v3"
,feature.columns = c("VDJ_cdr3s_aa"), grouping.column = "sample_id"
,metric = "shannon")
#For raw values use
plot$data

#Calculate Gini-simpson and Simpson index for VDJ and VJ CDR3s by sample
VDJ_diversity(VDJ = Platypus::small_vgm[[1]], platypus.version = "v3"
,feature.columns = c("VDJ_cdr3s_aa","VJ_cdr3s_aa"), grouping.column = "sample_id"
,metric = c("ginisimpson"))

#Calculate Jaccard index of J gene usage between two samples
VDJ_diversity(VDJ = Platypus::small_vgm[[1]], platypus.version = "v3"
,feature.columns = c("VDJ_jgene"), grouping.column = "sample_id"
,metric = "jaccard")

}
