% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_celltype_plot.R
\name{Spatial_celltype_plot}
\alias{Spatial_celltype_plot}
\title{Plotting celltype assign to cell according to their phenotype on the spatial image.}
\usage{
Spatial_celltype_plot(
  sample_names,
  bcs_merge,
  images_tibble,
  vgm_GEX,
  title,
  size,
  legend_title,
  unclassified_cells = c(TRUE, FALSE),
  specific_celltype = c("T", "B", "No", "Unclassified"),
  density = c(TRUE, FALSE)
)
}
\arguments{
\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{vgm_GEX}{Data frame containing GEX information (VGM[[2]]). It must have a barcode column containing GEX_barcode and a cell.state column (output from GEX_phenotype).}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{legend_title}{Character vector to name the legend scale.}

\item{unclassified_cells}{Booleans, if TRUE the unclassified cells are also plot and if FALSE they aren't plot exept if the parameter specific_celltype = "Unclassified". In this case the unclassified cells are displayed even unclassified_cells = FALSE. Default = FALSE.}

\item{specific_celltype}{Character vector, the user can choose to express a specific celltype like T, B or Unclassified cells. Default = No.}

\item{density}{Booleans, if TRUE a density map is made. Default = FALSE}
}
\value{
Returns a ggplot of the celltypes and if density = TRUE a density map of the cells on the spatial image.
}
\description{
Plotting celltype assign to cell according to their phenotype on the spatial image.
}
\examples{
\dontrun{
Spatial_celltype_plot(bcs_merge = scaling_parameters[[10]],
vgm_GEX = vgm_spatial$GEX@meta.data,images_tibble = scaling_parameters[[5]],
sample_names = sample_names,title="B and T celltype", legend_title = "Celltype",
unclassified_cells = FALSE, specific_celltype = "Unclassified")
}
}
