% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{make.Happyinf.input}
\alias{make.Happyinf.input}
\title{convert PolyHaplotyper input data to Happy-inf format}
\usage{
make.Happyinf.input(mrkDosage, indiv=NULL, haploblock,
ploidy, fname)
}
\arguments{
\item{mrkDosage}{matrix or data.frame of allele dosages; same as input for
inferHaplotypes. Markers are in rows, individuals in columns, each cell has
a marker dosage. All marker dosages must be in 0:ploidy or NA}

\item{indiv}{the names of the individuals to include in the Happy-inf
input data. Default NULL includes all individuals}

\item{haploblock}{a list of character vectors. The names are the names of the
haploblocks, the character vectors have the names of the markers in each
haploblock. Only the markers in haploblock will be included in the
Happy-inf input data}

\item{ploidy}{single integer: the ploidy level}

\item{fname}{filename of a tab-separated output file: this will contain the
data in Happy-inf format (the saved data.frame is also the return value).
If "" no file is written}
}
\value{
a data.frame in the Happy-inf input format: a header row with
"SNPID", "block" and names of the individuals and one row per marker, with
only the individuals, markers and blocks as specified.
#'SNPID has the marker names, "Block" the haploblock names. All markers
of a haploblock are in contiguous rows. Missing dosages
are represented by "NA"
}
\description{
convert PolyHaplotyper input data to Happy-inf format
for a single haploblock
}
\examples{
data(PolyHaplotyper_small)
HAPin <- make.Happyinf.input(mrkDosage=phdos, haploblock=phblocks,
                            ploidy=6, fname="")
HAPin[,1:8]
}
