% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{GCD}
\alias{GCD}
\alias{greatest_common_divisor}
\alias{GCD.polynom}
\alias{GCD.polylist}
\title{Greatest common divisor}
\usage{
GCD(...)

greatest_common_divisor(...)

\method{GCD}{polynom}(...)

\method{GCD}{polylist}(...)
}
\arguments{
\item{...}{A list of polynomials or polylist objects}
}
\value{
A polynomial giving the greatest common divisor, as defined above
}
\description{
Find a monic polynomial of maximal degree that divides each
of a set of polynomials exactly
}
\examples{
p <- poly_calc(0:5)
r <- poly_calc(1:6)
greatest_common_divisor(p, r)
solve(greatest_common_divisor(p, r))
lowest_common_multiple(p, r)
solve(lowest_common_multiple(p, r))
}
