% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuncionesAcceso.R
\name{Get}
\alias{Get}
\title{Acceder a la API del Portal de Datos}
\usage{
Get(
  series,
  start_date = NULL,
  end_date = NULL,
  representation_mode = NULL,
  collapse = NULL,
  collapse_aggregation = NULL,
  limit = 1000,
  timeout = 5,
  detail = FALSE
)
}
\arguments{
\item{series}{ID de la serie a obtener}

\item{start_date}{Fecha de inicio}

\item{end_date}{Fecha de final}

\item{representation_mode}{Indica el modo de representacion de las series}

\item{collapse}{Modifica la frecuencia de muestreo de los datos de la serie}

\item{collapse_aggregation}{Indica la función de agregacion temporal que debe usarse para homogeneizar la frecuencia temporal de todas las series solicitadas}

\item{limit}{Limite de datos a obtener (para evitar descargas fallidas siempre verificar el cumplimiento de los maximos permitidos por la API)}

\item{timeout}{Timeout para la conección a la API de datos}

\item{detail}{Agregar detalles a las series (requiere descarga de base de metadatos)}
}
\value{
Un objeto XTS con la serie seleccionada en ID
}
\description{
\code{Get} devuelve la serie seleccionada en series = ID. Para un detalle sobre las opciones
disponibles en parametros consultar:
\url{https://series-tiempo-ar-api.readthedocs.io/es/latest/}
}
\examples{
# Cargar serie mensual de TCN
TCN     <- Get("174.1_T_DE_CATES_0_0_32")
# Cargar serie mensual de TCN, transformada en anual y en variaciones
TCN <- Get("174.1_T_DE_CATES_0_0_32", start_date = 1999, collapse = "year",
collapse_aggregation = "avg", representation_mode = "percent_change")
}
