% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.covRob.R
\name{MycovRobTSGS}
\alias{MycovRobTSGS}
\title{Control settings for custom.covRob.TSGS}
\usage{
MycovRobTSGS(
  filter = c("UBF-DDC", "UBF", "DDC", "UF"),
  partial.impute = FALSE,
  tol = 1e-04,
  maxiter = 150,
  loss = c("bisquare", "rocke"),
  init = c("emve", "qc", "huber", "imputed", "emve_c")
)
}
\arguments{
\item{filter}{the filter to be used in the first step. Available choices are 
"UBF-DDC","UBF","DDC","UF". The default one is "UBF-DDC".}

\item{partial.impute}{whether partial imputation is used prior to estimation.
The default is FALSE.}

\item{tol}{tolerance for the convergence criterion. Default is 1e-4.}

\item{maxiter}{maximum number of iterations. Default is 150.}

\item{loss}{loss function to use, "bisquare" or "rocke". Default is "bisquare"}

\item{init}{type of initial estimator. Options include "emve", "qc", "huber","imputed","emve_c"}
}
\value{
a list of passed parameters
}
\description{
Auxiliary function for passing the estimation options as parameters 
to the estimation function custom.TSGS
}
