/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.template.exchange;

import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.QName;
import org.openfast.SequenceValue;
import org.openfast.error.FastConstants;
import org.openfast.session.SessionControlProtocol_1_1;
import org.openfast.session.template.exchange.AbstractFieldInstructionConverter;
import org.openfast.session.template.exchange.ConversionContext;
import org.openfast.session.template.exchange.FieldInstructionConverter;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegistry;

public class GroupConverter
extends AbstractFieldInstructionConverter {
    public Field convert(GroupValue fieldDef, TemplateRegistry templateRegistry, ConversionContext context) {
        String name = fieldDef.getString("Name");
        String namespace = "";
        if (fieldDef.isDefined("Ns")) {
            namespace = fieldDef.getString("Ns");
        }
        Field[] fields = GroupConverter.parseFieldInstructions(fieldDef, templateRegistry, context);
        boolean optional = fieldDef.getBool("Optional");
        Group group = new Group(new QName(name, namespace), fields, optional);
        if (fieldDef.isDefined("TypeRef")) {
            GroupValue typeRef = fieldDef.getGroup("TypeRef");
            String typeRefName = typeRef.getString("Name");
            String typeRefNs = "";
            if (typeRef.isDefined("Ns")) {
                typeRefNs = typeRef.getString("Ns");
            }
            group.setTypeReference(new QName(typeRefName, typeRefNs));
        }
        if (fieldDef.isDefined("AuxId")) {
            group.setId(fieldDef.getString("AuxId"));
        }
        return group;
    }

    public GroupValue convert(Field field, ConversionContext context) {
        Group group = (Group)field;
        Message groupMsg = GroupConverter.convert(group, new Message(SessionControlProtocol_1_1.GROUP_INSTR), context);
        groupMsg.setBool("Optional", field.isOptional());
        return groupMsg;
    }

    public boolean shouldConvert(Field field) {
        return field.getClass().equals(Group.class);
    }

    public Group[] getTemplateExchangeTemplates() {
        return new Group[]{SessionControlProtocol_1_1.GROUP_INSTR};
    }

    public static Message convert(Group group, Message groupMsg, ConversionContext context) {
        GroupConverter.setNameAndId(group, groupMsg);
        if (group.getTypeReference() != null && !FastConstants.ANY_TYPE.equals(group.getTypeReference())) {
            GroupValue typeRef = new GroupValue((Group)SessionControlProtocol_1_1.TYPE_REF.getField(new QName("TypeRef", "http://www.fixprotocol.org/ns/fast/scp/1.1")));
            GroupConverter.setName(typeRef, group.getTypeReference());
            groupMsg.setFieldValue("TypeRef", (FieldValue)typeRef);
        }
        SequenceValue instructions = new SequenceValue(SessionControlProtocol_1_1.TEMPLATE_DEFINITION.getSequence("Instructions"));
        int i = group instanceof MessageTemplate ? 1 : 0;
        Field[] fields = group.getFieldDefinitions();
        while (i < fields.length) {
            Field field = fields[i];
            FieldInstructionConverter converter = context.getConverter(field);
            if (converter == null) {
                throw new IllegalStateException("No converter found for type " + field.getClass());
            }
            GroupValue value = converter.convert(field, context);
            instructions.add(new FieldValue[]{value});
            ++i;
        }
        groupMsg.setFieldValue("Instructions", (FieldValue)instructions);
        return groupMsg;
    }

    public static Field[] parseFieldInstructions(GroupValue groupDef, TemplateRegistry registry, ConversionContext context) {
        SequenceValue instructions = groupDef.getSequence("Instructions");
        Field[] fields = new Field[instructions.getLength()];
        int i = 0;
        while (i < fields.length) {
            GroupValue fieldDef = instructions.get(i).getGroup(0);
            FieldInstructionConverter converter = context.getConverter(fieldDef.getGroup());
            if (converter == null) {
                throw new IllegalStateException("Encountered unknown group " + fieldDef.getGroup() + "while processing field instructions " + groupDef.getGroup());
            }
            fields[i] = converter.convert(fieldDef, registry, context);
            ++i;
        }
        return fields;
    }
}

