/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.ByteVectorValue;
import org.openfast.Global;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.NotStopBitEncodedTypeCodec;
import org.openfast.template.type.codec.TypeCodec;

public class NullableByteVector
extends NotStopBitEncodedTypeCodec {
    private static final long serialVersionUID = 1L;

    public ScalarValue decode(InputStream in) {
        ScalarValue decode = TypeCodec.NULLABLE_UNSIGNED_INTEGER.decode(in);
        if (decode == null) {
            return null;
        }
        int length = decode.toInt();
        byte[] encoding = new byte[length];
        int i = 0;
        while (i < length) {
            int nextByte;
            block5: {
                try {
                    nextByte = in.read();
                    if (nextByte >= 0) break block5;
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                catch (IOException e) {
                    Global.handleError(FastConstants.IO_ERROR, "An error occurred while decoding a nullable byte vector.", e);
                    return null;
                }
            }
            encoding[i] = (byte)nextByte;
            ++i;
        }
        return new ByteVectorValue(encoding);
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value.isNull()) {
            return TypeCodec.NULLABLE_UNSIGNED_INTEGER.encodeValue(ScalarValue.NULL);
        }
        ByteVectorValue byteVectorValue = (ByteVectorValue)value;
        byte[] length = TypeCodec.NULLABLE_UNSIGNED_INTEGER.encode(new IntegerValue(byteVectorValue.value.length));
        int lengthSize = length.length;
        byte[] encoding = new byte[byteVectorValue.value.length + lengthSize];
        System.arraycopy(length, 0, encoding, 0, lengthSize);
        System.arraycopy(byteVectorValue.value, 0, encoding, lengthSize, byteVectorValue.value.length);
        return encoding;
    }

    public ScalarValue getDefaultValue() {
        return new ByteVectorValue(new byte[0]);
    }

    public ScalarValue fromString(String value) {
        return new ByteVectorValue(value.getBytes());
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

