/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.message.type;

import java.util.HashMap;

public enum SessionStatusType {
    SESSION_ACTIVE(0),
    SESSION_PASSWORD_CHANGED(1),
    SESSION_PASSWORD_DUE_TO_EXPIRE(2),
    NEW_SESSION_PASSWORD_DOES_NOT_COMPLY_WITH_POLICY(3),
    SESSION_LOGOUT_COMPLETE(4),
    INVALID_USERNAME_OR_PASSWORD(5),
    ACCOUNT_LOCKED(6),
    LOGONS_NOT_ALLOWED(7),
    PASSWORD_EXPIRED(8);

    private static HashMap<Integer, SessionStatusType> codeValueMap;
    private final int code;

    private SessionStatusType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SessionStatusType getSessionStatusType(int codeValue) {
        return codeValueMap.get(codeValue);
    }

    static {
        codeValueMap = new HashMap();
        for (SessionStatusType type : SessionStatusType.values()) {
            codeValueMap.put(type.code, type);
        }
    }
}

