/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.message.type;

import java.util.HashMap;

public enum EncryptMethodType {
    NONE(0),
    PKCS(1),
    DES(2),
    PKCSDES(3),
    PGPDES(4),
    PGPDESMD5(5),
    PEM(6);

    private static HashMap<Integer, EncryptMethodType> codeValueMap;
    private final int code;

    static {
        codeValueMap = new HashMap();
        EncryptMethodType[] encryptMethodTypeArray = EncryptMethodType.values();
        int n = encryptMethodTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EncryptMethodType type = encryptMethodTypeArray[n2];
            codeValueMap.put(type.code, type);
            ++n2;
        }
    }

    private EncryptMethodType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static EncryptMethodType getEncryptMethodType(int codeValue) {
        return codeValueMap.get(codeValue);
    }
}

