% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R, R/utils.R
\name{cap_exposure}
\alias{cap_exposure}
\title{Apply post-weight exposure caps}
\usage{
cap_exposure(
  weights,
  max_per_symbol = NULL,
  group_map = NULL,
  max_per_group = NULL,
  allow_short = FALSE,
  renormalize = c("none", "down", "both"),
  renormalize_down = FALSE,
  renorm = NULL,
  cash_col = NULL,
  caps = NULL
)

cap_exposure(
  weights,
  max_per_symbol = NULL,
  group_map = NULL,
  max_per_group = NULL,
  allow_short = FALSE,
  renormalize = c("none", "down", "both"),
  renormalize_down = FALSE,
  renorm = NULL,
  cash_col = NULL,
  caps = NULL
)
}
\arguments{
\item{weights}{data.frame/data.table: columns \code{Date}, then symbols.}

\item{max_per_symbol}{numeric scalar or named vector (absolute cap per symbol).}

\item{group_map}{optional named character vector or data.frame(\code{symbol},\code{group}).}

\item{max_per_group}{optional numeric scalar (per-group gross cap).}

\item{allow_short}{logical; if \code{FALSE} clamp negatives to 0.}

\item{renormalize}{character: one of \code{"none"}, \code{"down"}, \code{"both"}. Default \code{"none"}.}

\item{renormalize_down}{logical; deprecated alias for down-only (kept for compatibility).}

\item{renorm}{logical; deprecated alias; if \code{TRUE} acts like \code{renormalize="both"}.}

\item{cash_col}{optional character; if provided, set to \code{1 - sum(pmax(w,0))}.}

\item{caps}{optional list; alternative to split args (see details above).}
}
\value{
data.table of capped (and optionally renormalized) weights.
}
\description{
Row-wise caps on a wide weights table (\code{Date} + symbols):
\enumerate{
\item per-symbol cap (\code{max_per_symbol})
\item optional per-group cap (\code{max_per_group}) using \code{group_map}
}
}
\details{
Negatives are clamped to 0 unless \code{allow_short = TRUE}.

Renormalization options:
\itemize{
\item \code{renormalize = "none"}: leave gross (sum of positive weights) as is.
\item \code{renormalize = "down"}: if gross > 1, scale down so gross == 1.
\item \code{renormalize = "both"}: if 0 < gross != 1, scale so gross == 1.
}

The argument \code{renorm} (logical) is a deprecated alias;
\code{TRUE} behaves like \code{renormalize = "both"}.

The \code{caps} list form is supported:
\describe{
\item{max_per_symbol}{Maximum absolute weight per symbol (0-1).}
\item{max_per_group}{Maximum gross weight per group (0-1).}
\item{group_map}{Named character vector mapping \code{symbol -> group}.}
}
}
