% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiparetoPR.R
\name{dBiparetoPR}
\alias{dBiparetoPR}
\title{BiparetoPR}
\usage{
dBiparetoPR(x)
}
\arguments{
\item{x}{vector of positive quantiles.}
}
\value{
\code{dBiparetoPR} gives the probability density function for  quotient of Bivariate Pareto random variables conditioned to the positive quadrant.

Invalid arguments will return an error message.
}
\description{
probability density function of quotient of Bivariate Pareto random variables  conditioned to the positive quadrant.For more detailed information please read the first reference paper.
}
\details{
Probability density function
\deqn{f_R (r \mid X > 0, Y > 0) = (r + 1)^{-2}}

For \eqn{r > 0},Nadarajah (2009) used this distribution to model the proportion of droughts defined as a quotient of drought durations and non-drought durations.
}
\examples{

x <- seq(0.1,5,0.1)
y <- dBiparetoPR(x)
plot(x,y,type = 'l')

}
\references{
Yuancheng Si and Saralees Nadarajah and Xiaodong Song, (2020). On the distribution of quotient of random variables conditioned to the positive quadrant. \emph{Communications in Statistics - Theory and Methods}, \bold{49}, pp2514-2528.


Mardia, K. V. (1962).Multivariate Pareto distributions.\emph{Annals of Mathematical Statistics}, \bold{33}, 1008-1015.

Nadarajah, S. (2009) A bivariate Pareto model for drought.\emph{Stochastic Environmental Research and Risk Assessment}, \bold{23}, pp811-822.
}
\author{
Saralees Nadarajah & Yuancheng Si \email{siyuanchengman@gmail.com}
}
