% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatepn.R
\name{pn.bayes}
\alias{pn.bayes}
\title{Fit univariate PN distribution (Bayesian)}
\usage{
pn.bayes(x,prior= "Jeffreys", shape_0 = NULL, rate_0 = NULL)
}
\arguments{
\item{x}{the response vector}
\item{prior}{the prior distribution of power parameter: "Jeffreys" (default), "Uniform" and "Gamma"}
\item{shape_0, rate_0}{shape and rate hyperparameters of the gamma distribution.}
}

\description{
Return the posterior mean, median and variance of power parameter for PN distribution
}

\references{

Agamez-Montavo, G. (2017). Modelos de mistura finita usando a classe de distribuicoes alpha potencia.
  \emph{Thesis (Doctoral)}, University of Sao Paulo.

}


\examples{

x <- rpn(100, 25)

pn.bayes(x)

pn.bayes(x, prior = 'Uniform')

pn.bayes(x, prior = 'Gamma', 1/100, 1/100)

}
