% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sales_groups}
\alias{sales_groups}
\title{Providing information about sales of products from one or more datasets}
\usage{
sales_groups(
  datasets = list(),
  start,
  end,
  shares = FALSE,
  barplot = FALSE,
  names = c()
)
}
\arguments{
\item{datasets}{A list of user's data frames. Each data frame must contain columns: \code{time} (as Date in format: year-month-day, e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{quantities} (as positive numeric).}

\item{start}{The beginning of the considered time interval (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The end of the considered time interval (as character) limited to the year and month, e.g. "2020-04".}

\item{shares}{A logical parameter indicating whether the function is to calculate shares of product sales}

\item{barplot}{A logical parameter indicating whether the function is to return barplot for product sales.}

\item{names}{A vector of characters describing product groups defined by \code{datasets}.}
}
\value{
The function returns values of sales of products from one or more datasets or the corresponding barplot for these sales (if \code{barplot} is TRUE). Alternatively, it calculates the sale shares (if \code{shares} is TRUE).
}
\description{
The function returns values of sales of products from one or more datasets or the corresponding barplot for these sales.
}
\examples{
## Creating 3 subgroups of milk:
\donttest{ctg<-unique(milk$description)}
\donttest{categories<-c(ctg[1],ctg[2],ctg[3])}
\donttest{milk1<-dplyr::filter(milk, milk$description==categories[1])}
\donttest{milk2<-dplyr::filter(milk, milk$description==categories[2])}
\donttest{milk3<-dplyr::filter(milk, milk$description==categories[3])}
## Sample use of this function:
\donttest{sales_groups(datasets=list(milk1,milk2,milk3),start="2019-04",end="2019-04",shares=TRUE)}
\donttest{sales_groups(datasets=list(milk1,milk2,milk3),start="2019-04",end="2019-07", 
barplot=TRUE, names=categories)}
}
