% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_new.R
\name{data_aggregating}
\alias{data_aggregating}
\title{Aggregating the user's data frame}
\usage{
data_aggregating(data, join_outlets = TRUE)
}
\arguments{
\item{data}{The user's data frame.}

\item{join_outlets}{A logical value indicating whether the data aggregation over outlets should be also done.}
}
\value{
The function aggregates the user's data frame over time and/or over outlets. Consequently, we obtain monthly data, where the unit value is calculated instead of a price for each \code{prodID} observed in each month (the \code{time} column gets the Date format: "Year-Month-01"). If the parameter \code{join_outlets} is TRUE, then the function also performs aggregation over outlets (retIDs) and the \code{retID} column is removed from the data frame. The main advantage of using this function is the ability to reduce the size of the data frame and the time needed to calculate the price index.
}
\description{
The function aggregates the user's data frame over time and optionally over outlets.
}
\examples{
#Example 1
data_aggregating(dataAGGR,join_outlets = FALSE)
data_aggregating(dataAGGR,join_outlets = FALSE)
#Example 2 (data frame reduction)
nrow(milk)
nrow(data_aggregating(milk))
}
