% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gen.sim.data}
\alias{gen.sim.data}
\title{\code{gen.sim.data}: Generate simulation data}
\usage{
gen.sim.data(
  n = 100,
  p = 50,
  s = 10,
  family = c("gaussian", "binomial", "poisson", "cox"),
  beta.min = 1,
  beta.max = 5,
  rho = 0,
  nu = 2,
  sig = 1,
  intercept = 0,
  scale = 2,
  shape = 1,
  rateC = 0.2
)
}
\arguments{
\item{n}{Number of observations. Default is 100.}

\item{p}{Number of explanatory variables. Default is 50.}

\item{s}{Number of true signals. It can only be an even number. Default is 10.}

\item{family}{A description of the error distribution and link function to be
used in the model. It can take the value of \verb{\code{gaussian}}, \verb{\code{binomial}},
\verb{\code{poisson}}, and \verb{\code{cox}}. Default is \verb{\code{gaussian}}}

\item{beta.min}{The smallest effect size in absolute value. Default is 1.}

\item{beta.max}{The largest effect size in absolute value. Default is 5.}

\item{rho}{Autocorrelation level. A numerical value between -1 and 1. Default is 0.}

\item{nu}{Signal to noise ratio in linear regression. Default is 2.}

\item{sig}{Standard deviation in the design matrix. Default is 1.}

\item{intercept}{Intercept of the linear predictor in the GLM. Default is 0.}

\item{scale}{Scale parameter in the Weibull distribution. Default is 2.}

\item{shape}{Shape parameter in the Weibull distribution. Default is 1.}

\item{rateC}{Rate of censoring in the survival data. Default is 0.2.}
}
\value{
A list of following components:
\describe{
\item{X}{The generated explanatory variable matrix}
\item{Y}{A vector of outcome. If \code{family} is \verb{\code{cox}}, a two-column
object is returned where the first column is the time and the second column is
status (0 is censoring and 1 is event)}
\item{index}{The indices of true signals }
\item{beta}{The true coefficient vector of length \code{p}}
}
}
\description{
This function can be used to generate autoregressive simulation data
}
\examples{
# generate data for linear regression
data.linear <- gen.sim.data(n = 20, p = 10, s = 4)

# extract x
x <- data.linear[[1]]

# extract y
y <- data.linear[[2]]

# extract the indices of true signals
index <- data.linear[[3]]

# extract the true coefficient vector
true.beta <- data.linear[[4]]

# generate data for logistic regression
data.logistic <- gen.sim.data(n = 20, p = 10, s = 4, family = "binomial")

# extract x
x <- data.logistic[[1]]

# extract y
y <- data.logistic[[2]]

# extract the indices of true signals
index <- data.logistic[[3]]

# extract the true coefficient vector
true.beta <- data.logistic[[4]]
}
