% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_met.R
\name{bayes_met}
\alias{bayes_met}
\title{Bayesian model for multi-environment trials}
\usage{
bayes_met(
  data,
  gen,
  env,
  repl,
  trait,
  reg = NULL,
  year = NULL,
  res.het = FALSE,
  iter = 2000,
  cores = 2,
  chains = 4,
  ...
)
}
\arguments{
\item{data}{A data frame containing the observations}

\item{gen, env}{A string. The name of the
column that corresponds to the evaluated genotype or environment.}

\item{repl}{A string, a vector, or \code{NULL}. If the trial is randomized in complete blocks,
\code{repl} will be a string representing the name of the column
that corresponds to the blocks. If the trial is randomized in incomplete blocks design,
\code{repl} will be a string vector containing the name of the column that corresponds to
the replicate and block effects on the first and second positions, respectively.
If the data do not have replicates, \code{repl} will be \code{NULL}.}

\item{trait}{A string. The name of the column that corresponds to the analysed variable.}

\item{reg}{A string or NULL. If the data set has information about regions,
\code{reg} will be a string with the name of the column that corresponds to the
region information. Otherwise, \code{reg = NULL} (default).}

\item{year}{A string or NULL. If the data set has information about time-related
environmental factors (years, seasons...), \code{year} will be a string with the
name of the column that corresponds to the time information. Otherwise, \code{year = NULL} (default).}

\item{res.het}{Logical, indicating if the model should consider heterogeneous
residual variances. Default is \code{FALSE}. If \code{TRUE}, the model will estimate one
residual variance per environment (or location)}

\item{iter}{Inherited from \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.
A positive integer specifying the number of iterations for each chains
(including warmup). The default is 2000.}

\item{cores}{Inherited from \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.
A positive integer specifying the number of cores to use when executing the
chains in parallel (defaults to 1).}

\item{chains}{Inherited from \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.
A positive integer specifying the number of Markov chains. The default is 4.}

\item{...}{Additional arguments passed to the \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} function
(for instance, to change the thin number, or to set a specific seed).
For more information, see \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} manual}
}
\value{
The function returns an object of S4 class stanfit containing the
fitted results
}
\description{
This function runs a Bayesian model for analyzing data from
Multi-environment trials using \code{rstan}, the \code{R} interface to \code{Stan}.
}
\details{
More details about the usage of \code{bayes_met}, as well as the other function of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
}
\examples{
\donttest{
mod = bayes_met(data = soy,
                gen = "Gen",
                env = "Env",
                repl = NULL,
                year = NULL,
                reg = "Reg",
                res.het = FALSE,
                trait = "Y",
                iter = 2000, cores = 2, chains = 4)
                }
}
\seealso{
\code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}
}
