% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreopt_functions.R
\name{total_score}
\alias{total_score}
\title{Total score (and gradient) for reconciled forecast}
\usage{
total_score(data, prob, S, Gvec, scorecode = 1, alpha = 1, matches = FALSE)
}
\arguments{
\item{data}{Past data realisations as vectors in a list.  Each list element corresponds to a period of training data.}

\item{prob}{List of functions to simulate from probabilistic forecasts.  Each list element corresponds to a period of training data. The output of each function should be a matrix.}

\item{S}{Matrix encoding linear constraints.}

\item{Gvec}{Reconciliation parameters \eqn{d} and \eqn{G} where \eqn{\tilde{y}=S(d+G\hat{y})}.  The first \eqn{m} elements correspond to translation vector \eqn{d}, while the remaining elements correspond to the matrix \eqn{G} where the elements are filled in column-major order.}

\item{scorecode}{Code that indicates score to be used.  This is set to 1 for the energy score and 2 for the variogram score.  Default is 1 (energy score)}

\item{alpha}{An additional parameter used for scoring rule.  Default is 1 (power used in energy score).}

\item{matches}{A flag that indicates whether to check for exact matches between samples from reconciled distribution.  This causes NaNs in the automatic differentiation.  For approaches that rely on bootstrapping set to T.  Otherwise set to F (the default) to speed up code.}
}
\value{
Total score and gradient w.r.t (d,G).
\item{grad}{The estimate of the gradient.}
\item{value}{The estimated total score.}
}
\description{
Function to find an estimate of the total energy score for a linearly reconciled
probabilistic forecast.  Also finds the gradient by automatic differentiation.
}
\examples{
#Use purr library to setup
library(purrr)
#Define S matrix
S<-matrix(c(1,1,1,0,0,1),3,2, byrow = TRUE)
#Randomly set a value of reconciliation parameters
Gvec<-as.matrix(runif(8))
#Set data (only 10 training observations used for speed)
data<-map(1:10,function(i){S\%*\%(c(1,1)+rnorm(2))})
#Set list of functions generating from probabilistic forecast
prob<-map(1:10,function(i){f<-function(){matrix(rnorm(3*50),3,50)}})
#Compute total score
out<-total_score(data,prob,S,Gvec)
}
\seealso{
Other ProbReco functions: 
\code{\link{inscoreopt}()},
\code{\link{scoreopt.control}()},
\code{\link{scoreopt}()}
}
\concept{ProbReco functions}
