% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcBreaks.R
\name{mcBreaks}
\alias{mcBreaks}
\title{Access Markov Chain Breaks for Run-Off Triangle Increments}
\usage{
mcBreaks(object)
}
\arguments{
\item{object}{An object of class \code{profileLadder}.}
}
\value{
The vector of the break points that define the set bins for the run-off
triangle increments.
}
\description{
Retrieves the Markov chain components from the \code{profileLadder} object returned
from the function \code{mcReserve()} or the \code{mcSetup} object returned
from the function \code{incrExplor()}. In particular, the function returns
the set of breaks used to define the bins for the incremental run-off triangle
increments.
}
\examples{
## MACRAME reserve prediction with the DEFAULT Markov chain setup 
output <- mcReserve(CameronMutual)

## Extracting the corresponding break points
mcBreaks(output)

}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=mcStates]{mcStates()}}, \code{\link[=mcTrans]{mcTrans()}}
}
