% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.permutedReserve.R
\name{summary.permutedReserve}
\alias{summary.permutedReserve}
\title{Summary Method for Objects of the S3 Class Method \code{permutedReserve}}
\usage{
\method{summary}{permutedReserve}(object, ...)
}
\arguments{
\item{object}{an object of the class \code{permutedReserve} -- i.e., the output
form the \code{permuteReserve()} functions}

\item{...}{not used}
}
\value{
Summary of the completed functional profiles (provided by one of the
functions \code{parallelReserve()} or \code{mcReserve()})  and the overall
reserve distribution obtained in terms of the permutation bootstrap -- the
function \code{permuteReserve()}.
The output is a list with the following items:
\item{origins}{a matrix with the row-specific summary of the completed
functional profiles (except the first fully developed profile---i.e., the first
row in the run-off triangle). The first column of the matrix (\code{First})
gives the first origin payments; The second column (\code{Latest}) gives
the last available (cumulative) payments (i.e., values from the last running
diagonal in the run-off triangle); The third column (\code{Dev.To.Date}) gives
a relative proportion of the paid amount (\code{Latest}) with respect to the
estimated ultimate (\code{Ultimate}) given in the fourth column; The column
denoted as \code{IBNR} gives the estimated amount still left to pay (Incurred
But Not Reported)}; The sixth column provides the estimated standard errors
(\code{S.E.}) of IBNR obtained from the permutation bootstrap; The last column returns
the corresponding coefficients of variation (\code{CV}).
\item{overall}{Table with the summary of the true/estimated reserve:
\code{Paid amount} represents the sum of the last running diagonal;
\code{Estimated reserve} gives the reserve estimate provided by one of the
estimation algorithm (PARALLAX, REACT, or MACRAME); \code{True reserve} is
given as a sum of the last column (if available, \code{NA} otherwise); Finally,
some Accuracy in terms of \code{Reserve\%} is given as a percentage of the
estimated reserve with respect to the true reserve (see Maciak, Mizera, and
Pešta (2022) and \code{Dev.To.Date} gives the proportion of the overall
estimatd ultimate and the overall paid amount}
\item{dist}{Table with basic empirical characteristics of the overall reserve
distribution provided by the permutation bootstrap: \code{Boot.Mean} stands
for the empirical mean of the bootstrap distribution; \code{Std.Er.} gives the
corresponding standard error of the bootstrap distribution; \code{BootCov\%}
stands for a percentage proportion between the standard error and the empirical
mean of the bootstrap distribution; Finally, \code{BootVar.xxx} provides the
estimated quantile of the bootstrap reserve distribution (0.995 by DEFAULT).}
}
\description{
The function provides an overall summary of the output from the functions
\code{permuteReserve()} (i.e., the summary of the object of the class
\code{permutedReserve})
}
\examples{
data(CameronMutual)
summary(CameronMutual)

## summary for the point reserve prediction
summary(parallelReserve(CameronMutual))

## summary for the overall reserve distribution
summary(permuteReserve(parallelReserve(CameronMutual)))

}
\seealso{
\code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}, \code{\link[=permuteReserve]{permuteReserve()}}
}
