% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_early_time.R
\name{early.time}
\alias{early.time}
\title{Early time for a deterministic projects}
\usage{
early.time(prec1and2 = matrix(0), prec3and4 = matrix(0), duration)
}
\arguments{
\item{prec1and2}{A matrix indicating the order of precedence type 1 and 2 between the activities (Default=matrix(0)). If value \eqn{(i,j)=1} then activity \eqn{i} precedes type \eqn{1} to \eqn{j}, and if \eqn{(i,j)=2} then activity \eqn{i} precedes type \eqn{2} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{prec3and4}{A matrix indicating the order of precedence type 3 and 4 between the activities (Default=matrix(0)). If value \eqn{(i,j)=3} then activity \eqn{i} precedes type \eqn{3} to \eqn{j}, and if \eqn{(i,j)=4} then activity \eqn{i} precedes type \eqn{4} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{duration}{vector with the duración for each activities.}
}
\value{
Early time vector.
}
\description{
This function calculates the early time for one project.
}
\examples{
prec1and2<-matrix(c(0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
duration<-c(3,2,1,1.5,4.2)
early.time(prec1and2,duration=duration)
}
\references{
\describe{
  \item{}{Burke, R. (2013). Project management: planning and control techniques. New Jersey, USA.}
}
}
