% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.config.R
\name{add.config}
\alias{add.config}
\title{Add project specific config to the global config}
\usage{
add.config(..., apply.override = FALSE)
}
\arguments{
\item{...}{A series of key-value pairs containing the configuration.  The key is the
name that gets added to the config object. These can be overridden at load
time through the \code{...} argument to \code{\link{load.project}}.}

\item{apply.override}{A boolean indicating whether overrides should be applied. This
can be used to add a setting disregarding arguments to \code{load.project}}
}
\description{
Enables project specific configuration to be added to the global config object.  The
allowable format is key value pairs which are appended to the end of the \code{config}
object, which is accessible from the global environment.
}
\details{
Once defined, the value can be accessed from any \code{ProjectTemplate} script by
referencing \code{config$my_project_var}.
}
\examples{
library('ProjectTemplate')
\dontrun{
add.config(
    keep_bigdata=TRUE,     # Whether to keep the big data file in memory
    parse=7                # number of fields to parse
)

if (config$keep_bigdata) ...
}
}
