% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sids.R
\name{get_sids}
\alias{get_sids}
\title{Retrieve Substance IDs (SIDs) from PubChem}
\usage{
get_sids(
  identifier,
  namespace = "cid",
  domain = "compound",
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A numeric or character vector specifying the identifiers for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{searchtype}{A character string specifying the search type. Default is NULL.}

\item{options}{Additional arguments passed to \code{\link{get_json}}.}
}
\value{
A tibble (data frame) where each row corresponds to a provided identifier and its SID.
        The tibble has columns 'CID' and 'SID'.
}
\description{
This function sends a request to PubChem to retrieve Substance IDs (SIDs) for a given identifier.
It returns a tibble (data frame) with the provided identifier and the corresponding SIDs.
}
\examples{
get_sids(
  identifier = "aspirin",
  namespace = "name"
)
}
