% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_pairwise.R
\name{compare_measures}
\alias{compare_measures}
\title{Compare method with Multiple Measures for a DGM}
\usage{
compare_measures(
  dgm_name,
  method,
  method_setting,
  measures = NULL,
  verbose = TRUE,
  estimate_col = "estimate",
  true_effect_col = "mean_effect",
  convergence_col = "convergence",
  method_replacements = NULL,
  n_repetitions = 1000,
  overwrite = FALSE,
  conditions = NULL
)
}
\arguments{
\item{dgm_name}{Character string specifying the name of the DGM dataset to download.}

\item{method}{Character vector of method names}

\item{method_setting}{Character vector of method settings, must be same length as method}

\item{measures}{Character vector of measures to compute. If NULL, computes all standard measures.}

\item{verbose}{Print detailed progress of the calculation.}

\item{estimate_col}{Character string specifying the column name containing parameter estimates. Default is "estimate"}

\item{true_effect_col}{Character string specifying the column name in conditions data frame containing true effect sizes. Default is "mean_effect"}

\item{convergence_col}{Character string specifying the column name containing convergence indicators. Default is "convergence"}

\item{method_replacements}{Named list of replacement method specifications. Each element should be named
with the "method-method_setting" combination (e.g., "RMA-default") and contain a named list with:
\itemize{
\item{\code{method}: Character vector of replacement method names}
\item{\code{method_setting}: Character vector of replacement method settings (same length as methods)}
\item{\code{power_test_type}: Optional character vector of power test types for each replacement method (same length as methods). If not specified, uses the main power_test_type parameter}
}
If multiple elements are specified within the vectors, these replacements are applied consecutively
in case the previous replacements also failed to converge.
Defaults to \code{NULL}, i.e., omitting repetitions without converged results on method-by-method basis.}

\item{n_repetitions}{Number of repetitions in each condition. Necessary method replacement. Defaults to \code{1000}.}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Defaults to \code{FALSE}, which means only missing files will be downloaded.}

\item{conditions}{Data frame of conditions from dgm_conditions()}
}
\value{
Invisible list of computed comparison data frames
}
\description{
This is a high-level wrapper function that computes multiple pairwise comparison
measures for a Data-Generating Mechanism (DGM) and saves the results to CSV files.
It provides a clean and extensible interface for comparing method performance.
}
