% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{downsample}
\alias{downsample}
\title{Downsample the data}
\usage{
downsample(data, SamplingRate = NULL, NewRate = NULL)
}
\arguments{
\item{data}{A data frame object created from \code{blink_cleanup}.}

\item{SamplingRate}{A postive integer specifying the current sampling rate.}

\item{NewRate}{A postive integer specifying the desired downsampled rate.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{downsample} reduces the sampling rate using median values for the
Pupil and gaze coordinates.
}
\examples{
# Load example data
data("Pupilex4")

dat <- downsample(Pupilex4, SamplingRate = 250, NewRate = 25)

# Please see the vignettes for detailed example usage.
vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
