% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{ppl_select_recorded_eye}
\alias{ppl_select_recorded_eye}
\title{Select the eye used during recording}
\usage{
ppl_select_recorded_eye(data, Recording = NULL, WhenLandR = NA)
}
\arguments{
\item{data}{A data table object output by \code{\link{create_time_series}}.}

\item{Recording}{A string indicating which eyes were used for recording gaze data
("R" when only right eye recording is present, "L" when only left eye recording
is present, "LorR" when either the left or the right eye was recorded, "LandR"
when both the left and the right eyes were recorded).}

\item{WhenLandR}{A string indicating which eye ("Right" or "Left) to use
if gaze data is available for both eyes (i.e., Recording = "LandR").}
}
\value{
A data table with 11 additional columns added to \code{data}.
}
\description{
\code{ppl_select_recorded_eye} examines each event and determines which
eye contains interest area information, based on the \code{Recording}
parameter (which can be determined using \code{\link{ppl_check_eye_recording}}).
This function then selects the data from the recorded eye and copies it to
new columns (Pupil, Gaze_X, Gaze_Y, Velocity_X, Velocity_Y, Acceleration_X,
Acceleration_Y, In_Blink, In_Saccade). The function prints a summary of the output.
}
\examples{
# Load example data
data("Pupilex2")

dat <- ppl_select_recorded_eye(data = Pupilex2, Recording = "R",
                               WhenLandR = "Right")

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
