% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_trial_obs_ontology}
\alias{get_trial_obs_ontology}
\title{Get the traits ontology/metadata of the current active trial}
\usage{
get_trial_obs_ontology()
}
\value{
a data frame of the traits ontology/metadata
}
\description{
This function will retrive the traits ontology/metadata of the current active 
trial as configured in the internal state object using `set_trial()` function.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# get observation variable ontology
ontology <- get_trial_obs_ontology()
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
