% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{gigwa_list_projects}
\alias{gigwa_list_projects}
\title{Get the List of All Projects in the Selected GIGWA Database}
\usage{
gigwa_list_projects()
}
\value{
A list of project names.
}
\description{
Retrieves the projects list from the currently active database as configured 
in the internal configuration object using the `gigwa_set_db()` function.
}
\examples{
if (interactive()) {
  # Configure your GIGWA connection
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)

  # Select a database by name
  gigwa_set_db("Sorghum-JGI_v1")

  # List existing projects
  gigwa_list_projects()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_db}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
