% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{gigwa_set_run}
\alias{gigwa_set_run}
\title{Set the Current Active GIGWA Run}
\usage{
gigwa_set_run(run_name)
}
\arguments{
\item{run_name}{The name of the run.}
}
\value{
No return value.
}
\description{
This function updates the current active run in the internal state object using the 
`studyDbIds` retrieved from GIGWA, which are associated with the given `run_name` parameter.
}
\examples{
if (interactive()) {
  # Configure your GIGWA connection
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)

  # Select a database by name
  gigwa_set_db("Sorghum-JGI_v1")

  # Select a project by name
  gigwa_set_project("Nelson_et_al_2011")
  
  # Select a specific run by name
  gigwa_set_run("run1")
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_project}}, \code{\link{gigwa_list_runs}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
