% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sas.R
\name{sas.cmprsk}
\alias{sas.cmprsk}
\title{Generate a Prediction Equation for a Competing Risks Regression Model}
\usage{
sas.cmprsk(f, time = NA, baseonly = FALSE, file = "", append = FALSE)
}
\arguments{
\item{f}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{time}{A single time point to calculate the failure probability}

\item{baseonly}{Should we only display the failure probability at the specified \code{time}? Defaults to \code{FALSE}.}

\item{file}{An optional connection or character string naming the file to print to.}

\item{append}{Only used if the \code{file} argument is specified. If \code{TRUE}, the output will be appended to \code{file}, otherwise it will overwritten.}
}
\value{
A printed equation using \code{\link{cat}} (invisible \code{NULL})
}
\description{
Uses \code{\link[rms]{Function}} to generate and print the linear predictor to the console or file which can be hard-coded into a function for evaluation on the scale of the original data. A time point can optionally be specified to retrieve the base sub-cumulative rate at that time point (i.e, the failure probability when all covariate values are 0).
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
sas.cmprsk(prostate.crr, time = 60)

}
\seealso{
\code{\link[QHScrnomo]{crr.fit}} \code{\link[rms]{sascode}} \code{\link[rms]{Function}}
}
\author{
Changhong Yu. Department of
Quantitative Health Sciences, Cleveland Clinic
}
