% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newlevels.R
\name{Newlevels.cmprsk}
\alias{Newlevels.cmprsk}
\title{Change the Level Labels of Categorical Predictors for a Competing Risks Regression Model}
\usage{
\S3method{Newlevels}{cmprsk}(fit, levels, \dots)
}
\arguments{
\item{fit}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{levels}{A list of named vectors specifying the new level labels for categorical predictors.}

\item{...}{Other arguments for \code{\link[rms]{Newlevels}}}
}
\value{
A new \code{\link[QHScrnomo]{crr.fit}} object with adjusted labels on the factor levels
}
\description{
Uses the \code{\link[rms]{Newlevels}} function to change the labels predictors when constructing a nomogram.
}
\note{
This will override \code{parms} and \code{\link[rms]{datadist}} information that were stored with the fit.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
prostate.g <- Newlevels(prostate.crr, list(TX = c('Treatment 1', 'Treatment 2', 'Treatment 3')))

}
\seealso{
\code{\link[QHScrnomo]{Newlabels.cmprsk}}
}
\author{
Changhong Yu. Department of
Quantitative Health Sciences, Cleveland Clinic
}
\keyword{attributes}
