% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred.ci}
\alias{pred.ci}
\title{Extract Cumulative Incidence Estimates at a Specified Time Point}
\usage{
pred.ci(cum, tm1, failcode = 1)
}
\arguments{
\item{cum}{A \code{\link[cmprsk]{cuminc}} object}

\item{tm1}{A single time point to return the cumulative incidence at}

\item{failcode}{The value of the status column that indicates the event of interest}
}
\value{
A \code{\link{data.frame}} with 3 columns:
\item{Group}{The group name. If the \code{group} argument was used in the \code{\link[cmprsk]{cuminc}} fit, there will be one row per group. Otherwise this is non-informative.}
\item{CI.Prob}{The cumulative incidence probability at the desired time point}
\item{CI.Var}{The estimated variance of the cumulative incidence estimate}
}
\description{
Extracts the cumulative incidence estimates from a \code{\link[cmprsk]{cuminc}} object for the cause of interest at a specified time point into a \code{\link{data.frame}}.
}
\examples{
 cum <- cmprsk::cuminc(prostate.dat$TIME_EVENT, prostate.dat$EVENT_DOD, cencode = 0)
 pred.ci(cum, 60, failcode = 1)

}
\seealso{
\code{\link[cmprsk]{cuminc}}
}
\author{
Michael W. Kattan, Ph.D. and Changhong Yu.\cr Department of Quantitative Health Sciences, Cleveland Clinic
}
