% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.bandwidth.R
\name{rdq.bandwidth}
\alias{rdq.bandwidth}
\title{Bandwidth estimation}
\usage{
rdq.bandwidth(y, x, d, x0, z0=NULL, cov, cv, val,hp=NULL,pm.each=1,
     bdy=1,p.order=1,xl=0.5,print.qte=1)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{a vector (or a matrix) of covariates, the first column is the running variable.}

\item{d}{a numeric vector, the treatment status.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.}

\item{cov}{either 0 or 1. Set \emph{cov=1} when covariates are present in the model;
otherwise set \emph{cov=0}.}

\item{cv}{either 0 or 1. When \emph{cv=1}, both the CV and MSE optimal bandwidths
are produced. When \emph{cv=0}, the MSE optimal bandwidth is produced.}

\item{val}{a set of candidate values for the CV bandwidth.}

\item{hp}{a pilot bandwidth to estimate nuisance parameters for the MSE optimal bandwidth.
It will be used only if \emph{cv=0}. If \emph{cv=1}, the CV bandwidth will be used
as the pilot bandwidth to compute the MSE optimal bandwidth.}

\item{pm.each}{either 0 or 1. When \emph{pm.each=1}, the CV bandwidths for each side of the cutoff will be obtained separately.}

\item{bdy}{either 0 or 1. When \emph{bdy=1}, the CV bandwidth uses the boundary point procdure.}

\item{p.order}{either 1 or 2. When \emph{p.order=1}, a local linear regression is used, and
when \emph{p.order=2}, a local quadratic regression is used.}

\item{xl}{if \emph{xl=0.5}, the CV bandwidth use the 50\% of observations closest to \eqn{x_0}.}

\item{print.qte}{a logical flag specifying whether to print an outcome table.}
}
\value{
A list with elements:
\describe{
\item{cv}{the selected CV bandwidth at the median.}
\item{opt.p}{the MSE optimal bandwidth at the median from the right side of \eqn{x_0}.}
\item{opt.m}{the MSE optimal bandwidth at the median from the left side of \eqn{x_0}.}
}
}
\description{
\code{rdq.bandwidth} implements two bandwidth selection rules and obtains the cross-validation (CV) bandwidth and the MSE optimal bandwidth.
}
\examples{
# Without covariate
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
rdq.bandwidth(y=y,x=x,d=d,x0=0,z0=NULL,cov=0,cv=1,val=(1:4))
rdq.bandwidth(y=y,x=x,d=d,x0=0,z0=NULL,cov=0,cv=0,val=(1:4),hp=2)

# (continued) With covariates
z = sample(c(0,1),n,replace=TRUE)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + d*z + rnorm(n)
rdq.bandwidth(y=y,x=cbind(x,z),d=d,x0=0,z0=c(0,1),cov=1,cv=1,val=(1:4),bdy=1,p.order=1)

}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168

Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323
}
