% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0coef_dichotom.R
\name{coef_dichotom}
\alias{coef_dichotom}
\title{Regression Coefficients of Dichotomized Predictors}
\usage{
coef_dichotom(
  formula,
  data,
  contX,
  dX = m_rpartD(y = eval(formula[[2L]], envir = data), X = data[[contX]])
)
}
\arguments{
\item{formula}{\link[stats]{formula}, left-hand-side being the endpoint and
right-hand-side being the predictors \emph{in addition to} the \link[base]{numeric} predictor(s) to be dichotomized.
If there is no additional predictors, use \code{y ~ 1}}

\item{data}{\link[base]{data.frame}}

\item{contX}{\link[base]{character} scalar,
name of the \link[base]{matrix} column in \code{data}
which contains the \link[base]{numeric} predictor(s) to be dichotomized.
This parameter is not needed if parameter \code{dX} is provided}

\item{dX}{(optional) \link[base]{logical} \link[base]{matrix}, dichotomized \code{data[[contX]]}.
Default is the returned object from \link{m_rpartD},}
}
\value{
\link{coef_dichotom} returns a \link[base]{numeric} \link[base]{vector} of the
coefficients of dichotomized predictor(s), with \link[base]{attributes}
\describe{
\item{\code{attr(,'model')}}{the \link[survival]{coxph}, \link[stats]{glm} or \link[stats]{lm} regression model}
\item{\code{attr(,'branch')}}{see \link{m_rpartD}}
}
}
\description{
Regression coefficients of dichotomized predictors
}
\details{
..
}
