% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0splitSample_dichotom.R
\name{median_splitSample_dichotom}
\alias{median_splitSample_dichotom}
\title{Median Effect Size for Multiple Sample Splits}
\usage{
median_splitSample_dichotom(
  y,
  x,
  splitIDs = stratifiedSplitSample(y, ...),
  ...
)
}
\arguments{
\item{y}{a \link[survival]{Surv} object, a \link[base]{logical} \link[base]{vector},
or a \link[base]{numeric} \link[base]{vector}, the endpoint}

\item{x}{\link[base]{numeric} \link[base]{vector}, the predictor}

\item{splitIDs}{(optional) a \link[base]{list}.
Each element of \code{splitIDs} is a length-2 \link[base]{list} of \link[base]{integer} \link[base]{vector}s,
the indexes of \code{'train'} and \code{'test'} set.
Default value is a \emph{series of} sample splits (via \link{stratifiedSplitSample})
based on the endpoint \code{y}.}

\item{...}{additional parameters for \link{stratifiedSplitSample} if \code{splitIDs} is missing,
most importantly the copies of sample splits \code{nsplit}}
}
\value{
\link{median_splitSample_dichotom} returns an object of S3 class \link{splitSample_dichotom}.
}
\description{
Defining the median of multiple \link{splitSample_dichotom} objects,
as the \link{splitSample_dichotom} object with
the median of the regression coefficient of dichotomized predictor (\code{attr(,'coef')}).
}
\details{
Given a \emph{series of} sample splits \code{splitIDs},

\enumerate{

\item {for each sample split, use \link{splitSample_dichotom}}

\item {finds the nearest-even median (\code{type = 3} of \link[stats]{quantile})
of the regression coefficient of dichotomized predictor \code{attr(,'coef')},
from all \link{splitSample_dichotom} objects obtained in Step 1}

\item {returns the \link{splitSample_dichotom} object
with the median regression coefficient of dichotomized predictor, identified in Step 2}

}
}
