% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikRatio.R
\name{LikRatio}
\alias{LikRatio}
\title{Likelihood Ratio Test for General Models}
\usage{
LikRatio(dots, type = c("plain", "vuong"), compare = c("seq", "first"), ...)
}
\arguments{
\item{dots}{a \link[base]{list} of regression models, or a \link[base]{list} of \link[stats]{logLik} objects.}

\item{type}{\link[base]{character} scalar, ordinary likelihood ratio test (\code{'plain'}, default)
or Vuong's closeness test for non-nested models (\code{'vuong'}).}

\item{compare}{type of comparison between the models, sequentially (\code{'seq'}, default) or 
all models versus the first model (\code{'first'})}

\item{...}{additional arguments of \link[stats]{logLik} function(s)}
}
\value{
\link{LikRatio} returns an \link[stats:anova]{ANOVA} table for likelihood ratios test, 
or a \code{'vuong'} object for Vuong's test.
}
\description{
Likelihood ratio test for models fitted by R.
}
\examples{
# no examples for now

}
\references{
Vuong's closeness test, \doi{10.2307/1912557}.
}
\seealso{
\link[lmtest]{lrtest.default}
}
