% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose-response-analysis.R
\name{fl.drFitModel}
\alias{fl.drFitModel}
\title{Perform a biosensor model fit on response vs. concentration data of a single sample.}
\usage{
fl.drFitModel(conc, test, drID = "undefined", control = fl.control())
}
\arguments{
\item{conc}{Vector of concentration values.}

\item{test}{Vector of response parameter values of the same length as \code{conc}.}

\item{drID}{(Character) The name of the analyzed condition}

\item{control}{A \code{fl.control} object created with \code{\link{fl.control}}, defining relevant fitting options.}
}
\value{
A \code{drFitFLModel} object.
\item{raw.conc}{Raw data provided to the function as \code{conc}.}
\item{raw.test}{Raw data for the response parameter provided to the function as \code{test}.}
\item{drID}{(Character) Identifies the tested condition}
\item{fit.conc}{Fitted concentration values.}
\item{fit.test}{Fitted response values.}
\item{model}{\code{nls} object generated by the \code{\link{nlsLM}} function.}
\item{parameters}{List of parameters estimated from dose response curve fit.}
\itemize{
\item \code{yEC50}: Response value related to EC50.
\item \code{y.min}: Minimum fluorescence ('leakiness', if lowest concentration is 0).
\item \code{y.max}: Maximum fluorescence.
\item \code{fc}: Fold change (\code{y.max} divided by \code{y.min}).
\item \code{K}: Concentration at half-maximal response ('sensitivity').
\item \code{n}: Cooperativity.
\item \code{yEC50.orig}: Response value for EC50 in original scale, if a transformation was applied.
\item \code{K.orig}: K in original scale, if a transformation was applied.
\item \code{test.nm}: Test identifier extracted from \code{test}.
}
\item{fitFlag}{(Logical) Indicates whether a spline could fitted successfully to data.}
\item{reliable}{(Logical) Indicates whether the performed fit is reliable (to be set manually).}
\item{control}{Object of class \code{fl.control} created with the call of \code{\link{fl.control}}.}
Use \code{\link{plot.drFitModel}} to visualize the model fit.
}
\description{
\code{fl.drFitModel} fits the biosensor model proposed by Meyer et al. (2019) to the provided response (e.g., \code{max_slope.spline} vs. concentration data to determine the leakiness, sensitivity, induction fold-change, and cooperativity.
}
\examples{
# Create concentration values via a serial dilution
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)

# Simulate response values via biosensor equation
response <- biosensor.eq(conc, y.min = 110, y.max = 6000, K = 0.5, n = 2) +
            0.01*6000*rnorm(10)

# Perform fit
TestRun <- fl.drFitModel(conc, response, drID = 'test', control = fl.control())

print(summary(TestRun))
plot(TestRun)
}
\references{
Meyer, A.J., Segall-Shapiro, T.H., Glassey, E. et al. \emph{Escherichia coli “Marionette” strains with 12 highly optimized small-molecule sensors.} Nat Chem Biol 15, 196–204 (2019). DOI: 10.1038/s41589-018-0168-3
}
