% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior2macro.R
\name{prior2macro}
\alias{prior2macro}
\title{Translates informative prior information into a concise MLwiN macro.}
\usage{
prior2macro(prior, formula, levID, D, indata)
}
\arguments{
\item{prior}{An R list object containing prior information for a multilevel
model. See `Details' below.}

\item{formula}{A formula object; see
\code{\link{Formula.translate}} or \code{\link{Formula.translate.compat}}.}

\item{levID}{A string vector specifying the level ID(s).}

\item{D}{A character string/vector specifying the distribution of the
current model.}

\item{indata}{A data.frame object containing the variables to be modelled.}
}
\value{
A long vector is returned in the format of MLwiN macro language. This
includes all the specified prior parameters.
}
\description{
An internal function which takes an R list object containing informative
prior information for a multilevel model and translates it into a concise
vector object to be used in an MLwiN macro.
}
\details{
The \code{prior} list can contain the following:
\itemize{
\item \code{fixe}: For the fixed
parameters, if proper normal priors are used for some parameters, a list of
vectors of length two is provided, each of which specifies the mean and the
standard deviation. If not given, default ('flat' or 'diffuse') priors are
used for the parameters.
\item \code{fixe.common}: For multivariate normal,
multinomial and mixed response models, if common coefficients are added, use
\code{fixe.common} rather than \code{fixe}.
\item \code{fixe.sep}: If the common
coefficients are added, use \code{fixe.sep} for the separate coefficients.
\item \code{rp<level number>}: A list object specifying the Wishart or gamma prior for the
covariance matrix or scalar variance at the levels specified, e.g. \code{rp1} for
level 1, \code{rp2} for level 2, etc. Consists of: (1)
\code{estimate} -- an estimate for the true value of the inverse of the
covariance matrix; (2) \code{size} -- the number of rows in the covariance
matrix. Note that this is a weakly-informative prior and the default prior
is used if missing.
}
}
\seealso{
\code{\link{runMLwiN}}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
