% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{modify.data}
\alias{modify.data}
\title{Function to modify genotype and phenotype data to match}
\usage{
modify.data(pheno.mat, geno.mat, pheno.labels = NULL,
  geno.names = NULL, map = NULL, return.ZETA = TRUE,
  return.GWAS.format = FALSE)
}
\arguments{
\item{pheno.mat}{A \eqn{n _ 1 \times p} matrix of phenotype data. rownames(pheno.mat) should be genotype (line; accesion; variety) names.}

\item{geno.mat}{A \eqn{n _ 2 \times m} matrix of marker genotype data. rownames(geno.mat) should be genotype (line; accesion; variety) names.}

\item{pheno.labels}{A vector of genotype (line; accesion; variety) names which correpond to phenotypic values.}

\item{geno.names}{A vector of genotype (line; accesion; variety) names for marker genotype data (duplication is not recommended).}

\item{map}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.}

\item{return.ZETA}{If this argument is TRUE, the list for mixed model equation (ZETA) will be returned.}

\item{return.GWAS.format}{If this argument is TRUE, phenotype and genotype data for GWAS will be returned.}
}
\value{
\describe{
\item{$geno.modi}{The modified marker genotype data.}
\item{$pheno.modi}{The modified phenotype data.}
\item{$ZETA}{The list for mixed model equation (ZETA).}
\item{$pheno.GWAS}{GWAS formatted phenotype data.}
\item{$geno.GWAS}{GWAS formatted marker genotype data.}
}
}
\description{
Function to modify genotype and phenotype data to match
}
