% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_gwas.R
\name{SS_gwas}
\alias{SS_gwas}
\title{Calculate some summary statistics of GWAS (genome-wide association studies) for simulation study}
\usage{
SS_gwas(
  res,
  x,
  map.x,
  qtn.candidate,
  gene.set = NULL,
  n.top.false.block = 10,
  sig.level = c(0.05, 0.01),
  method.thres = "BH",
  inflator.plus = 2,
  LD_length = 150000,
  cor.thres = 0.35,
  window.size = 0,
  saveName = NULL,
  plot.ROC = TRUE
)
}
\arguments{
\item{res}{Data frame of GWAS results where the first column is the marker names,
the second and third column is the chromosome amd map position, and the forth column is -log10(p) for each marker.}

\item{x}{A N (lines) x M (markers) marker genotype data (matrix), coded as {-1, 0, 1} = {aa, Aa, AA}.}

\item{map.x}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.}

\item{qtn.candidate}{A vector of causal markers. You should assign where those causal markers are positioned in our marker genotype,
rather than physical position of those causal markers.}

\item{gene.set}{If you have information of gene (or haplotype block), and if you used it to perform kernel-based GWAS,
you should assign your gene information to gene.set in the form of a "data.frame" (whose dimension is (the number of gene) x 2).
In the first column, you should assign the gene name. And in the second column, you should assign the names of each marker,
which correspond to the marker names of "x" argument.}

\item{n.top.false.block}{We will calculate the mean of -log10(p) values of top 'n.top.false.block' blocks
to evaluate the inflation level of results. The default is 10.}

\item{sig.level}{Significance level for the threshold. The default is 0.05.}

\item{method.thres}{Method for detemining threshold of significance. "BH" and "Bonferroni are offered.}

\item{inflator.plus}{If `the -log10(p) value for each marker` exceeds (`the inflation level` + `inflator.plus`),
that marker is regarded as significant.}

\item{LD_length}{SNPs within the extent of LD are regareded as one set. This LD_length determines the size of LD block,
and 2 x LD_length (b.p.) will be the size of LD block.}

\item{cor.thres}{SNPs within the extent of LD are regareded as one set. This cor.thres also determines the size of LD block,
and the region with square of correlation coefficients >= cor.thres is regareded as one LD block. More precisely, the regions
which satisfies both LD_length and cor.thres condition is rearded as one LD block.}

\item{window.size}{If you peform SNP-set analysis with slinding window, we can consider the effect of window size by this argument.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveName = NULL, the plot is not saved.}

\item{plot.ROC}{If this argunent is TRUE, ROC (Reciever Operating Characteristic) curve will be drawn with AUC (Area Under the Curve).}
}
\value{
\describe{
\item{$log.p}{-log10(p)) values of the causals.}
\item{$qtn.logp.order}{The rank of -log10(p) of causals.}
\item{$thres}{A vector which contains the information of threshold.}
\item{$overthres}{The number of markers which exceed the threshold.}
\item{$AUC}{Area under the curve.}
\item{$AUC.relax}{Area under the curve calculated with LD block units.}
\item{$FDR}{False discovery rate. 1 - Precision.}
\item{$FPR}{False positive rate.}
\item{$FNR}{False negative rate. 1 - Recall.}
\item{$Recall}{The proportion of the number of causals dected by GWAS to the number of causals you set.}
\item{$Precision}{The proportion of the number of causals dected by GWAS to the number of markers detected by GWAS.}
\item{$Accuracy}{The accuracy of GWAS results.}
\item{$Hm}{Harmonic mean of Recall and Precision.}
\item{$haplo.name}{The haplotype block name which correspond to causals.}
\item{$mean.false}{The mean of -log10(p) values of top 'n.top.false.block' blocks.}
\item{$max.trues}{Maximum of the -log10(p) values of the region near causals.}
}
}
\description{
Calculate some summary statistics of GWAS (genome-wide association studies) for simulation study
}
