% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.cells.R
\name{graph.cells}
\alias{graph.cells}
\title{Data visualization}
\usage{
graph.cells(input, year=FALSE, interact=FALSE)
}
\arguments{
\item{input}{an \code{\link{is.raptor}} file.}

\item{year}{a numerical value specifying the year of interest. Default starts with the first year and plots the other years in sequence.}

\item{interact}{a logical flag. If \code{\link{TRUE}}, the user can interactively cycle through plots of annual rings (default = \code{\link{FALSE}}).}
}
\description{
This function uses \code{\link{is.raptor}} files to create a two panel \code{\link{plot}} including; 1) a schematic overview of the ring width sequence and 2) a graphical representation of the cell size and position within a specific year (highlighted in the ring width sequence).
}
\details{
This graphical interface aids in exploring the cell position and cell size. The upper \code{\link{plot}} provides and overview of the available years within the \code{\link{data.frame}}. Grey shading indicates the year that is presented in the lower panel. The italic value in the upper panel presents the number of cells within the selected year. The lower panel shows the position of the cells with their unique "CID". XCAL and YCAL positions are standardized to the minimum occurring coordinates. Within the lower panel, the grey boxes represent the cells, derived from the lumen area ("CA") assuming a square. When "interact = \code{\link{TRUE}}", \code{\link{readline}} messages will be presented with multiple options to create a new \code{\link{plot}} while moving along the years (including selecting the previous, next year or selecting a specific year). Stopping the interact function is done by typing "x". Terminate this function before continuing with other functions.
}
\examples{
#' #plotting example data
input<-example.data(species="LOT_PICEA")
input<-is.raptor(input, str=TRUE)
graph.cells(input, year=2010)
}
