% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEU_GAUSSIAN_raw.R
\name{SEU_GAUSSIAN_raw}
\alias{SEU_GAUSSIAN_raw}
\title{Sequential Estimation-adjusted Urn Model (Gaussian Responses)}
\usage{
SEU_GAUSSIAN_raw(x.df, urn_comp, arms, group_allo,
add_rule_index, add_rule)
}
\arguments{
\item{x.df}{A data frame of two columns: treatment arm and response value.
treatment arm.}

\item{urn_comp}{A vector of current urn composition.}

\item{arms}{A vector of arm names. If it is not provided, the arms occurred
in x.df will be assumed as all possible arms. Suggest to always assign arms.}

\item{group_allo}{An integer of the size of group allocation. The default is
1.}

\item{add_rule_index}{Supply a number of 1 or 2 indicting the
addition rules to target allocation functions.
1 = the SEU model targeting Neyman allocation;
2 = the SEU model that assigns probability of 0.6+1/K to winner at each step.
The default is 1.}

\item{add_rule}{Supply a user-specified addition rules function of x.df and
arms when add_rule_index is NULL. Default is NULL.}
}
\value{
Number of the arm that the next subject is assigned to.
}
\description{
Allocates patients to one of treatments based on sequential
estimation-adjusted urn model (SEU) on summarized data.
}
\details{
'SEU_GAUSSIAN' assigns the next subject to a group given the observed
success rates, enrolled subjects and allocation function.
}
\examples{
x.df = data.frame(
ARM = sample(LETTERS[1:2],50,replace = TRUE),
RESPONSE = rnorm(50)
)

SEU_GAUSSIAN_raw(x.df,
urn_comp=c(0,0),
arms=c("A","B"),
group_allo = 1,
add_rule_index = 1)

}
