\name{RC.feedback.computation}
\alias{RC.feedback.computation}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fetch all feedback about a computation
}
\description{
This function fetches all feedback messages that have been submitted by any user about the computation.
}
\usage{
RC.feedback.computation(pk = "", echo = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pk}{
primary key of the computation
}
  \item{echo}{
boolean parameter which indicates whether the number of records should be displayed
}
}
\details{
This function submits a query to the repository at www.freestatistics.org. The result is sent back (via HTTP) and returned in the form of a data frame. The feedback that is submitted may be of great importance within the context of peer review. The quality and quantity of peer review messages (generated by students within the context of statistics education) can be shown to be strongly related to exam results. Experimental research has shown that submitting peer review is highly beneficial and causes deep learning (publication forthcoming).
}
\value{
The function returns a data frame with the following items:
%%  If it is a LIST, use
  \item{pk}{primary key of the feedback message}
  \item{pk_frcomp}{primary key of the computation}
  \item{username}{the name of the user who posted the feedback}
  \item{userid}{the User ID of the person who posted the feedback}
  \item{text}{the actual feedback message}
  \item{date}{the date of submission}
  \item{pk_parent}{primary key of 'parent' feedback message (this is zero if the message has no parent)}
  \item{usernamenotvisible}{a boolean variable which indicates whether the user wishes to remain anonymous (if this variable is 1 then the username and userid will be 'Anonymous'}
%% ...
}
\examples{
#Fetch the feedback messages that were submitted about the computation with pk = 22149 [not run]
#r <- RC.feedback.computation(pk=22149)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ peer review }
\keyword{ forum }
\keyword{ feedback }

