% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_prepositions}
\alias{get_prepositions}
\title{Extract prepositions from row and column labels}
\usage{
get_prepositions(
  labels,
  notation = RCLabels::bracket_notation,
  prepositions = RCLabels::prepositions
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{notation}{The notation object that describes the labels.
Default is \code{RCLabels::bracket_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions}.}
}
\value{
A list of prepositions.
}
\description{
This function extracts prepositions from a list of row and column labels.
The list has outer structure of the number of labels and
an inner structure of each prepositional phrase in the specific label.
}
\examples{
get_prepositions(c("a [of b into c]", "d [-> e of f]"))
}
