% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_piece}
\alias{get_piece}
\title{Get a piece of a label}
\usage{
get_piece(
  labels,
  piece = "all",
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = FALSE,
  prepositions = RCLabels::prepositions_list
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{piece}{The name of the item to return.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{x}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{The notation type to be used when extracting prepositions.
Default is \code{RCLabels::notations_list}, meaning that
the notation is inferred using \code{infer_notation()}.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \code{RCLabels::notations_list},
the default value of \code{FALSE} means that
\code{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\code{RCLabels::from_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions_list}.}
}
\value{
A \code{piece} of \code{labels}.
}
\description{
This is a wrapper function for \code{get_pref_suff()}, \code{get_nouns()}, and
\code{get_objects()}.
It returns a \code{piece} of a row or column label.
}
\details{
\code{piece} is typically one of
\itemize{
\item "all" (which returns \code{labels} directly),
\item "pref" (for the prefixes),
\item "suff" (for the suffixes),
\item "noun" (returns the noun),
\item "pps" (prepositional phrases, returns prepositional phrases in full),
\item "prepositions" (returns a list of prepositions),
\item "objects" (returns a list of objects with prepositions as names), or
\item a preposition in \code{prepositions} (as a string), which will return
the object of that preposition named by the preposition itself.
}

\code{piece} must be a character vector of length 1.

If a \code{piece} is missing in a label, "" (empty string) is returned.
}
\examples{
labs <- c("a [from b in c]", "d [of e in f]", "Export [of Coal from USA to MEX]")
get_piece(labs, "pref")
get_piece(labs, "suff")
get_piece(labs, piece = "noun")
get_piece(labs, piece = "pps")
get_piece(labs, piece = "prepositions")
get_piece(labs, piece = "objects")
get_piece(labs, piece = "from")
get_piece(labs, piece = "in")
get_piece(labs, piece = "of")
get_piece(labs, piece = "to")
}
