% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO-download.R
\name{downloadGEO}
\alias{downloadGEO}
\title{Download GEO data}
\usage{
downloadGEO(GEOID, platform, protocol = c("affymetrix", "agilent"), destDir)
}
\arguments{
\item{GEOID}{The ID of the GEO dataset.}

\item{platform}{The platform of selected GEO dataset.}

\item{protocol}{The protocol of the selected GEO dataset, including affymetrix and agilent.}

\item{destDir}{A path to save downloaded data.}
}
\value{
A SummarizedExperiment object including the processed data.
}
\description{
This function download and process data from GEO for microarray and RNASeq data.
}
\examples{
\donttest{
library(RCPA)
# Affymetrix
downloadPath <- file.path(tempdir(), "GSE5281")
if(!dir.exists(downloadPath)) dir.create(downloadPath)
affyDataset <- RCPA::downloadGEO(GEOID = "GSE5281", platform ="GPL570",
                                 protocol ="affymetrix", destDir = downloadPath)

# Agilent
downloadPath <- file.path(tempdir(), "GSE61196")
if(!dir.exists(downloadPath)) dir.create(downloadPath)
agilDataset <- RCPA::downloadGEO(GEOID = "GSE61196", platform ="GPL4133",
                                 protocol ="agilent", destDir = downloadPath)
}
}
