% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{fit.svyglm}
\alias{fit.svyglm}
\title{Calculates model fit statistics for a svyglm linear regression model}
\usage{
fit.svyglm(svyglm, digits = 3)
}
\arguments{
\item{svyglm}{An object of type svyglm. This object is the output of the svyglm function as well as regC function with w argument.}

\item{digits}{Number of digits to report after decimal place, optional (default = 3).}
}
\value{
Returns a numeric vector of R-Squared and Adjusted R-sSquared statistics.
}
\description{
Model fit statistics for a svyglm weighted linear regression model (not for weighted logistic regression).
}
\examples{
   library(RCPA3)
   
   \donttest{
   ft.police.model <- regC(ft.police ~ race.ethnicity, w=wt, data=nes)
   fit.svyglm(ft.police.model)
   }
}
\keyword{internal}
