% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_lambda}
\alias{calculate_lambda}
\title{calculates factor loadings of common factors}
\usage{
calculate_lambda(
  robust,
  Y,
  X,
  beta_est,
  comfactor,
  factor_group,
  g,
  lgfg_list,
  k,
  kg,
  method_estimate_beta,
  method_estimate_factors,
  verbose = FALSE,
  initialise = FALSE
)
}
\arguments{
\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{comfactor}{common factors}

\item{factor_group}{estimated group specific factors}

\item{g}{Vector with group membership for all individuals}

\item{lgfg_list}{This is a list (length number of groups) containing FgLg for every group.}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{verbose}{when TRUE, it prints messages}

\item{initialise}{indicator of being in the initialisation phase}
}
\value{
Returns a matrix where each row contains a common factor. If the number of estimated common factors equals zero, it returns a matrix with 1 row, containing zero's.
}
\description{
calculates factor loadings of common factors
}
