% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calSize}
\alias{calSize}
\title{Calculate the  accumulated sample size distribution by each wave.}
\usage{
calSize(n0, m, maxT, p_list_vec, tol)
}
\arguments{
\item{n0}{Number of seeds.}

\item{m}{Number of coupons issued to each participant.}

\item{maxT}{Planned field period.}

\item{p_list_vec}{A vector of recruitment rates.}

\item{tol}{Accuracy loss limit.}
}
\value{
a list consisting of the following elements:
\item{P_tau_list}{vector; a vector of extinction probability at each wave.}
\item{Fk}{list; probability mass function of the accumulated sample size by each wave, k=1,...,maxT.}
}
\description{
Calculate the  accumulated sample size distribution by each wave.
}
\examples{
result <- calSize(n0=10,m=3,maxT=9,p_list_vec=rep(0.3,9),tol=0.005)

}
