% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KWDual.R
\name{KWDual}
\alias{KWDual}
\title{Dual optimization for Kiefer-Wolfowitz problems}
\usage{
KWDual(A, d, w, ...)
}
\arguments{
\item{A}{Linear constraint matrix}

\item{d}{constraint vector}

\item{w}{weights for \code{x} should sum to one.}

\item{...}{other parameters passed to control optimization:  These may
include \code{rtol} the relative tolerance for dual gap convergence criterion,
\code{verb} to control verbosity desired from mosek, \code{verb = 0} is quiet,
\code{verb = 5} produces a fairly detailed iteration log,
\code{method} controls the choice of optimizer:  by default this is "mosek"
which employs interior point methods, however if \code{method = "pogs"} then
optimization is carried out by the ADMM methods described in Fougner and
Boyd (2015).  This is a first order descent method most suitable for large
problems for which parallelization is desirable.  For most REBayes applications
the default "mosek" method is appropriate and "pogs" should be considered
experimental.  Note that there is not yet a "pogs" implementation for \code{medde} problems.
Note also that \code{method = "pogs"} assumes a distinct control list.
Users are responsible for specifying correctly named control variables for each method.
The most advantageous implementation of "pogs" requires (CUDA) GPU hardware.
\code{control} is a control list consisting of sublists \code{iparam},
\code{dparam}, and \code{sparam}, containing elements of various mosek
control parameters.  See the Rmosek and Mosek manuals for further details.
A prime example is \code{rtol} which should eventually be deprecated and
folded into \code{control}, but will persist for a while for compatibility
reasons.  The default for \code{rtol} is 1e-6, but in some cases it is
desirable to tighten this, say to 1e-10.  Another example that motivated the introduction of
\code{control} would be \code{control = list(iparam = list(num_threads =
1))}, which forces Mosek to use a single threaded process.  The default
allows Mosek to uses multiple threads (cores) if available, which is
generally desirable, but may have unintended (undesirable) consequences when running
simulations on clusters.}
}
\value{
Returns a list with components: \item{f}{dual solution vector, the
mixing density} \item{g}{primal solution vector, the mixture density
evaluated at the data points} \item{logLik}{log likelihood}
\item{status}{return status from Mosek}
}
\description{
Interface function for calls to optimizer from various REBayes functions
There are currently two options for the optimization:  Mosek (the default)
is the original, preferred option and uses interior point methods.
It relies on the \pkg{Rmosek} interface to R available from
\url{http://rmosek.r-forge.r-project.org}
See userguide for Rmosek for further details.  A more experimental option
employs the \pkg{pogs} package available from \url{https://github.com/foges/pogs}
and employs an ADMM (Alternating Direction Method of Multipliers) approach.
}
\author{
R. Koenker
}
\references{
Koenker, R and I. Mizera, (2014) ``Convex Optimization, Shape Constraints,
Compound Decisions, and Empirical Bayes Rules,'' \emph{JASA}, 109, 674--685.

Mosek Aps (2015) Users Guide to the R-to-Mosek Optimization Interface,
\url{http://rmosek.r-forge.r-project.org}.

Fougner, C. (2015) POGS: Proximal Operator Graph Solver, R Package available from
\url{http://foges.github.io/pogs}.

Fougner, C. and S. Boyd, (2015) Parameter Selection and Pre-Conditioning for a
Graph Form Solver, Stanford Technical Report.
}
\keyword{nonparametrics}

